<?php

class ReviewSiteSetting extends ReviewSiteApp
{	
	var $data;
	var $value;
	var $status;
	var $prefix	= "reviewsite_";
	var $ys_options	= array(
						"yes"	=> "yes",
						"no"	=> "no",
					  );
	
	// init
	function init()
	{
		add_action("admin_menu",array(&$this,"createMenu"));
	}
	
	// create menu
	function createMenu()
	{
		add_submenu_page( 'reviewSite', 'Review Site &bull; Theme Setting', 'Theme Setting', 'manage_categories', 'reviewSite-setting', array(&$this,"view"));
	}
	
	/*==================================================================================*/
	/*=========================			  CONTROLLER		   =========================*/
	/*==================================================================================*/
	
	// processing Input
	function processingInput()
	{
		if(isset($_POST['data']) && isset($_POST['_wpnonce'])) :
			check_admin_referer('reviewSite-update-theme-setting');
			$this->data	= $_POST['data'];
			
			$this->updateData();
		endif;
	}
	
	// generate value from custom options
	function generateValue()
	{
		
		$this->value	= array(
			'home'		=> array(
				'slider'		=> stripslashes(get_option($this->prefix.'home_slider')),
				'header_image'	=> stripslashes(get_option($this->prefix.'home_header_image')),
				'header'		=> stripslashes(get_option($this->prefix.'home_header')),
				'review'		=> stripslashes(get_option($this->prefix.'home_review')),
				'review_total'	=> stripslashes(get_option($this->prefix.'home_review_total')),
				'youtube'		=> stripslashes(get_option($this->prefix.'home_youtube')),
				'video_link'	=> stripslashes(get_option($this->prefix.'home_video_link')),
			),
			'opt-in'	=> array(
				'image'		=> stripslashes(get_option($this->prefix.'opt-in_image')),
				'title'		=> stripslashes(get_option($this->prefix.'opt-in_title')),
				'text'		=> stripslashes(get_option($this->prefix.'opt-in_text')),
				'form'		=> stripslashes(get_option($this->prefix.'opt-in_form')),
			),
			'exit-popup'=> array(
				'activate'	=> stripslashes(get_option($this->prefix.'exit-popup_activate')),
				'message'	=> stripslashes(get_option($this->prefix.'exit-popup_message')),
				'redirect'	=> stripslashes(get_option($this->prefix.'exit-popup_redirect')),
			),
			'social'	=> array(
				'facebook'	=> stripslashes(get_option($this->prefix.'social_facebook')),
				'twitter'	=> stripslashes(get_option($this->prefix.'social_twitter')),
			),
		);
		
		//echo("generate value : <pre>");print_r($this->value);echo("</pre><br /><br />");
	}
	
	// updateData
	function updateData()
	{


		$array_keys	= array_keys($this->data);
		
		foreach($array_keys as $key) :
			if(is_array($this->data[$key])) :
				$value	= implode(',',$this->data[$key]);
			else :
				$value	= $this->data[$key];
			endif;
			
			update_option($key,$value);
		endforeach;
		
		$this->status	= "update";
	}
	
	/*==================================================================================*/
	/*=========================				VIEW			   =========================*/
	/*==================================================================================*/
	
	// notification
	function notification()
	{
		$this->processingInput();
		$this->generateValue();
		
		if($this->status == "update") :
		?><div class="message updated fade"><p>Settings have been updated</p></div><?php
		endif;
	}
	
	// view
	function view()
	{
		global $reviewsite_nextgen;
	
		$this->notification();
		
		?>
        <div id="reviewSite-body" class="wrap">
        	<h2>ReviewSite Theme Setting</h2>
            
            <div style="margin:10px 0" id="ReviewSite-nav">
            	<a href="#header-reviewSite">Home</a> |
            	<a href="#optin-reviewSite">Opt-in Form</a> |
            	<a href="#exit-reviewSite">Exit PopUp</a> |
                <a href="#social-reviewSite">Social</a>
            </div>
            
            <script type="text/javascript" language="javascript1.2">
				jQuery(document).ready(function(){
					jQuery("#ReviewSite-nav a").click(function(){
						var targetID = jQuery(this).attr('href');
						
						jQuery(".ReviewSite-body").hide();
						jQuery(targetID).fadeIn();
						
						return false;
					});
				});
			</script>
            
			<form name="form1" method="post" action="">
            <script type="text/javascript" language="javascript1.2" src="<?php echo THEMELINK; ?>/admin/js/nicEdit.js"></script>
            
            <?php
			//==========================================================================================//
			//======================					 HOME 			          ======================//
			//==========================================================================================//
			?>
	
			<div id="header-reviewSite" class="metabox-holder ReviewSite-body"  style="width:90% !important;">
				<div class="postbox">
                	<h3>Home</h3>
                    
					<div class="inside">
                        <?php parent::generateCategoryOptions("Slideshow Category"	,"home",'slider'); ?>
                        <?php parent::generateCategoryOptions("Review Category"		,"home",'review'); ?>   
						<?php parent::generateImageUpload("Header Image"			,"home","header_image",true); ?>                      
                        <?php parent::generateInputTextarea("Header Content"		,"home",'header',true); ?>
                        <?php parent::generateInputText("Total Review on Sidebar"	,"home",'review_total'); ?>
                        <?php parent::generateInputText("Youtube Video on Sidebar <br />".
														"<em>only provide youtube ID ex <strong>DXrYJttXTQY</strong></em>","home",'youtube'); ?>
                        <?php parent::generateInputText("Video Link on Sidebar"		,"home",'video_link'); ?>
					</div>                   
				</div>    
			</div>
            
            <?php
			//==========================================================================================//
			//======================				  OPTIN FORM 			      ======================//
			//==========================================================================================//
			?>
	
			<div id="optin-reviewSite" class="metabox-holder ReviewSite-body"  style="width:90% !important;display:none;">
				<div class="postbox">
                	<h3>Opt-in Form</h3>
                    
                    <div class="inside">
                        <?php parent::generateInputText("Form Title"			,"opt-in",'title'); ?>
						<?php parent::generateImageUpload("Form Image"			,"opt-in","image",true); ?>                        
                        <?php parent::generateInputTextarea("Form Description"	,"opt-in",'text',true); ?>   
                        <?php parent::generateInputTextarea("Opt-in Code"		,"opt-in",'form'); ?>                     
                    </div>
                </div>
            </div>
            
            <?php
			//==========================================================================================//
			//======================				  EXIT POPUP 			      ======================//
			//==========================================================================================//
			?>
            
			<div id="exit-reviewSite" class="metabox-holder ReviewSite-body"  style="width:90% !important;display:none;">
				<div class="postbox">
                	<h3>Exit PopUp</h3>
                    
                    <div class="inside">
                        <?php parent::generateOptions('Activate Exit PopUp'		,"exit-popup","activate",$this->ys_options)?>
                        <?php parent::generateInputText("Redirect URL"			,"exit-popup",'redirect'); ?> 
                        <?php parent::generateInputTextarea("Message Exit"		,"exit-popup",'message',true); ?>   
                    </div>
                </div>
            </div>
            
            <?php
			//==========================================================================================//
			//======================					SOCIAL 			       	  ======================//
			//==========================================================================================//
			?>
			<div id="social-reviewSite" class="metabox-holder ReviewSite-body"  style="width:90% !important;display:none;">
				<div class="postbox">
                	<h3>Social</h3>
                    
					<div class="inside">
                        <?php parent::generateInputText("Facebook Link"	,"social",'facebook'); ?>
                        <?php parent::generateInputText("Twitter Link"	,"social",'twitter'); ?>
					</div>                   
				</div>    
			</div>
            
            <div class="input-button" style="clear:both;">
            	<?php parent::generateTinyMCE(); ?>
	            <?php wp_nonce_field('reviewSite-update-theme-setting'); ?>
                <input type="submit" class="button-primary" name="savethis" value="<?php _e('Save Settings', 'ReviewSite') ?>" />
            </div>
		
			</form>
        </div>
        
        <?php
	}
}

$reviewsite_setting	= new ReviewSiteSetting;
$reviewsite_setting->init();

?>